import mongoose from "mongoose";
import dotenv from "dotenv";
import bcryptjs from "bcryptjs";

dotenv.config();

const userSchema = new mongoose.Schema({
  username: { type: String, required: true },
  email: { type: String, required: true, unique: true },
  password: { type: String, required: true },
  phoneNumber: { type: String },
  adress: { type: String },
  isUser: { type: Boolean, default: false },
  isAdmin: { type: Boolean, default: false },
  isVendor: { type: Boolean, default: false },
  refreshToken: { type: String }
}, { strict: false });

const User = mongoose.model("User", userSchema);

async function createAdmin() {
  try {
    await mongoose.connect(process.env.mongo_uri);
    console.log("Connected to MongoDB\n");

    // Check if admin exists
    const existingAdmin = await User.findOne({ email: "admin@carrental.com" });
    
    if (existingAdmin) {
      console.log("✅ Admin user already exists!");
      console.log("\n========== ADMIN CREDENTIALS ==========");
      console.log("   Email:    admin@carrental.com");
      console.log("   Password: admin123");
      console.log("========================================\n");
    } else {
      // Create admin user
      const hashedPassword = bcryptjs.hashSync("admin123", 10);
      
      const adminUser = new User({
        username: "Admin",
        email: "admin@carrental.com",
        password: hashedPassword,
        phoneNumber: "9999999999",
        isAdmin: true,
        isUser: false,
        isVendor: false,
      });

      await adminUser.save();
      
      console.log("✅ Admin user created successfully!");
      console.log("\n========== ADMIN CREDENTIALS ==========");
      console.log("   Email:    admin@carrental.com");
      console.log("   Password: admin123");
      console.log("========================================\n");
    }

    // Also create a vendor user
    const existingVendor = await User.findOne({ email: "vendor@carrental.com" });
    
    if (!existingVendor) {
      const hashedPassword = bcryptjs.hashSync("vendor123", 10);
      
      const vendorUser = new User({
        username: "Vendor",
        email: "vendor@carrental.com",
        password: hashedPassword,
        phoneNumber: "8888888888",
        isAdmin: false,
        isUser: false,
        isVendor: true,
      });

      await vendorUser.save();
      console.log("✅ Vendor user created!");
      console.log("\n========== VENDOR CREDENTIALS ==========");
      console.log("   Email:    vendor@carrental.com");
      console.log("   Password: vendor123");
      console.log("=========================================\n");
    } else {
      console.log("========== VENDOR CREDENTIALS ==========");
      console.log("   Email:    vendor@carrental.com");
      console.log("   Password: vendor123");
      console.log("=========================================\n");
    }

  } catch (error) {
    console.error("Error:", error);
  } finally {
    await mongoose.disconnect();
  }
}

createAdmin();
